create or replace view OOBJ_NFE_ENVIO as 
select
	null            as nfe_id,      -- Chave da view OOBJ_NFE_ENVIO	   
	null			as indSinc, 	 -- Indicador de processamento síncrono. 0=NÃO; 1=SIM=Síncrono
	null            as cUF,         -- Código da UF do emitente do Documento Fiscal
	null            as cNF,         -- Código númerico que compõe a Chave de acesso
	null            as natOp,       -- Descrição da Natureza da Operação
	null            as serie,       -- Série do Documento Fiscal
	null            as nNF,         -- Número do Documento Fiscal
	null            as dhEmi,       -- Data de emissão do Documento       
	null            as dhSaiEnt,    -- Date e Hora de saída ou da Entrada da Mercadoria/Produto       
	null            as tpNF,        -- Tipo do Documento Fiscal	   
	null            as idDest,		 -- Identificador de Local de destino da operação (1-Interna;2-Interestadual;3-Exterior)
	null            as cMunFG,      -- Código do Município de Ocorrência do Fato Gerador
	null            as tpImp,       -- Formato de Impressão do DANFE       
	null            as tpEmis,	     -- Forma de Emissão da NF-e	   
	null            as cDV,         -- Digito verificador da Chave de Acesso da NF-e
	null            as tpAmb,       -- Identificação do Ambiente
	null            as finNFe,      -- Finalidade de emissão da NF-e
	null			as indFinal,	 -- Indica operação com consumidor final (0-Não;1-Consumidor Final)
	null			as indPres, 	 -- Indicador de presença do comprador no estabelecimento comercial no momento da oepração (0-Não se aplica (ex.: Nota Fiscal complementar ou de ajuste;1-Operação presencial;2-Não presencial, internet;3-Não presencial, teleatendimento;4-NFC-e entrega em domicílio;5 - Operação presencial, fora do estabelecimento;9-Não presencial, outros)
	null			as mod,         -- Utilizar 55 para identificação da NF-e, emitida em substituição ao modelo 1 e 1A e 65 para NFC-e. Se não informado, será considerado 55
	-- Informações de envio de e-mail
	null            as emailCopia,  -- Lista para envio automático de emails
	0               as enviarDANFE, -- Determina o envio do DANFE por email
	0               as enviarBoleto, -- Determina o envio do Boleto por email
	-- Informações de Contingência
	null            as dhCont,      -- Data e Hora de Entrada em contingência
	null            as xJust,       -- Justificativa de entrada em contigência
	null            as qrCode,      -- Texto com o QR Code impresso no DANFe NFC-e (NT 2015-002)
	-- Identificação do Emitente da Nota Fiscal Eletrônica	   
	null            as emitCNPJ,    -- CNPJ do emitente	   
	null            as emitCPF,     -- CPF do emitente	   
	null            as emitXNome,   -- Razão Social ou Nome do emitente
	null            as emitXFant,   -- Nome Fantasia
	null            as emitIE,      -- IE
	null            as emitIEST,    -- IE do Substituto Tributário
	null            as emitIM,      -- Inscrição Municipal
	null            as emitCNAE,    -- CNAE Fiscal
	null            as emitCRT,     -- Código do Regime Tributário
	-- Endereço do Emitente
	null            as emitXLgr,    -- Logradouro
	null            as emitNro,     -- Número
	null            as emitXCpl,    -- Complemento
	null            as emitXBairro, -- Bairro
	null            as emitCMun,    -- Código do município 
	null            as emitXMun,    -- Nome do município
	null            as emitUF,      -- Sigla da UF
	null            as emitCEP,     -- Código do CEP
	null            as emitCPais,   -- Código do País
	null            as emitXPais,   -- Nome do País
	null            as emitFone,    -- Telefone (DDD + Telefone)
	-- Identificação do Fisco Emitente da NF-e
	null            as avulsoCNPJ,    -- CNPJ do Orgão Emitente
	null            as avulsoxOrgao,  -- Órgão Emitente
	null            as avulsoMatr,    -- Matrícula do agente
	null            as avulsoxAgente, -- Nome do agente
	null            as avulsoFone,    -- Telefone
	null            as avulsoUF,      -- Sigla da UF
	null            as avulsonDAR,    -- Número do Documento de Arrecadação de Receita
	null            as avulsodEmi,    -- Data de emissão do Documento de Arrecadação
	null            as avulsovDAR,    -- Valor Total constante no  Documento de arrecadação de Receita 
	null            as avulsorepEmi,  -- Repartição Fiscal emitente
	null            as avulsodPag,    -- Data de pagamento do Documento de Arrecadação
	-- Identificação do Destinatário da Nota Fiscal Eletrônica	   
	null            as destCNPJ,    -- CNPJ do destinatário	   
	null            as destCPF,     -- CPF do destinatário	   
	null			 as destIdEstrangeiro, -- Identificador do destinatário, em caso de comprador estrangeiro
	null            as destXNome,   -- Razão Social ou Nome do destinatário
	null            as destIE,      -- IE
	null            as destISUF,    -- Inscrição na SUFRAMA
	null            as destEmail,   -- Endereço de email do destinatário
	null            as IMDest,		 --	inscrição estadual do tomador de serviço destinatário;	texto 15 (opcional)
	null            as indIEDest,   --	indicador do tipod e contribuição do destinatario;		inteiro (1 - contribuinte ICMS pag a vista, 2 - contribuinte isento de inscrição, 9 - não contribuinte) 
	-- Endereço do destinatário 
	null            as destXLgr,    -- Logradouro
	null            as destNro,     -- Número
	null            as destXCpl,    -- Complemento
	null            as destXBairro, -- Bairro
	null            as destCMun,    -- Código do município
	null            as destXMun,    -- Nome do município
	null            as destUF,      -- Sigla da UF
	null            as destCEP,     -- Código do CEP
	null            as destCPais,   -- Código do País
	null            as destXPais,   -- Nome do País
	null            as destFone,    -- Telefone (DDD + Telefone)
	-- Identificação do Local de Retirada da mercadoria
	null            as retCNPJ,     -- CNPJ do Local de retirada
	null            as retCPF,      -- CPF do local de retirada
	null            as retXLgr,     -- Logradouro
	null            as retNro,      -- Número
	null            as retCpl,      -- Complemento
	null            as retXBairro,  -- Bairro
	null            as retCMun,     -- Código do Município
	null            as retXMun,     -- Nome do Município
	null            as retUF,       -- Sigla da UF
	null			as retNome,     -- Razão Social ou Nome do Expedidor
	null			as retCEP, 		-- Código do CEP
	null			as retCPais, 	-- Código do País
	null			as retXPais, 	-- Nome do País
	null 			as retFone, 	-- Telefone
	null			as retEmail, 	-- Endereço de e-mail do Expedidor
	null 			as retIE, 		-- Inscrição Estadual do Estabelecimento Expedidor
	-- Identificação do Local de Entrega da mercadoria
	null            as entCNPJ,     -- CNPJ do Local de entrega
	null            as entCPF,      -- CPF do Local de entrega
	null            as entXLgr,     -- Logradouro
	null            as entNro,      -- Número
	null            as entXCpl,     -- Complemento
	null            as entXBairro,  -- Bairro
	null            as entCMun,     -- Código do Município
	null            as entXMun,     -- Nome do Município
	null            as entUF,       -- Sigla da UF
	null			as entNome,  	-- Razão Social ou Nome do Recebedor
	null			as entCEP,		-- Código do CEP
	null			as entCPais, 	-- Código do País
	null			as entXPais,	-- Nome do País
	null			as entFone, 	-- Telefone
	null			as entEmail, 	-- Endereço de e-mail do Recebedor
	null 			as entIE, 		-- Inscrição Estadual do Estabelecimento Recebedor
	-- Valores Totais da NF-e
	null            as ICMSVBC,     -- Base de cálculo do ICMS
	null            as vICMS,       -- Valor total do ICMS
	null			as vFCP,	-- Valor total do Fundo de Combate à Pobreza
	null            as vBCST,       -- Base de cálculo do ICMS ST
	null            as vST,         -- Valor tota do ICMS ST
	null			as vFCPST,	-- Valor Total do FCP (Fundo de Combate à Pobreza) retido por substituição tributária)
	null			as vFCPSTRet,	-- Valor Total do FCP retido anteriormente por Substituição Tributária
	null            as vProd,       -- Valor total dos produtos e serviços
	null            as vFrete,      -- Valor total do frete
	null            as vSeg,        -- Valor total do seguro
	null            as vDesc,       -- Valor total do desconto
	null            as vIPI,        -- valor total do IPI
	null			as vIPIDevol	-- Valor Total do IPI Devolvido
	null            as vII,         -- Valor total do II
	null            as vPIS,        -- Valor do PIS
	null            as vCOFINS,     -- Valor do COFINS
	null            as vOutro,      -- Outras Despesas acessórias
	null            as vNF,         -- Valor total da NF-e
	null			as vTotTrib,	 -- Valor total estimado de impostos
	null            as vICMSDeson,  -- valor de icms de desoneração        decimal 15,2 (15 digitos, sendo dois decimais)
	null			 as vFCPUFDest,  -- Valor total do ICMS relativo ao Funco de Combate à Pobreza para a UF de destino
	null			 as vICMSUFDest, -- Valor total do ICMS para a UF de destino
	null			 as vICMSUFRemet,-- Valor total do ICMS para a UF do remetente
	null			 as qBCMono,-- Valor total da quantidade tributada do ICMS monofásico próprio
    null			 as vICMSMono,-- Valor total do ICMS monofásico próprio
    null			 as qBCMonoReten,-- Valor total da quantidade tributada do ICMS monofásico sujeito a retenção
    null			 as vICMSMonoReten,-- Valor total do ICMS monofásico sujeito a retenção
	null			 as qBCMonoRet,-- Valor total da quantidade tributada do ICMS monofásico retido anteriormente
	null			 as vICMSMonoRet,-- Valor do ICMS monofásico retido anteriormente
	-- Totais referentes ao ISSQN
	null            as vServ,       -- Valor total dos Serviços
	null            as vBCISS,      -- Base de Cálculo do ISS
	null            as vISS,        -- Valor total do ISS
	null            as servVPIS,    -- Valor do PIS sobre serviços
	null            as servVCOFINS, -- Valor do COFINS sobre serviços
	null			 as dCompet, 	 -- Data da prestação do serviço  (AAAA-MM-DD)
	null			 as vDeducao, 	 -- Valor dedução para redução da base de cálculo
	null 			 as vOutroRet, 	 -- Valor outras retenções
	null			 as vDescIncond, -- Valor desconto incondicionado
	null			 as vDescCond, 	 -- Valor desconto condicionado
	null			 as vISSRet, 	 -- Valor Total Retenção ISS
	null		  	 as cRegTrib, 	 -- Código do regime especial de tributação
	-- Totais referentes a RETTRIB
	null            as vRetPIS,     -- Valor retido de PIS
	null            as vRetCOFINS,  -- Valor retido de COFINS
	null            as vRetCSLL,    -- Valor retido de CSLL
	null            as vBCIRRF,     -- Base de cálculo do IRRF
	null            as vIRRF,       -- Valor retido do IRRF
	null            as vBCRetPrev,  -- Base de Cálculo da Retenção da Previdência Social
	null            as vRetPrev,    -- Valor da Retenção da Previdência Social
	-- Modalidade de frete
	null            as modFrete,    -- Modalidade de frete
	-- Transportadora	   
	null            as transpCNPJ,  -- CNPJ	   
	null            as transpCPF,   -- CPF
	null            as transpXNome, -- Razão Social ou Nome
	null            as transpIE,    -- Inscrição Estadual
	null            as transpXEnder,-- Endereço Completo
	null            as transpUF,    -- Sigla da UF
	null            as transpXMun,  -- Nome do Município
	-- RET Transp
	null            as vServTransp, -- Valor do Serviço
	null            as vBCRet,      -- BC da Retenção do ICMS
	null            as pICMSRet,    -- Alíquota da Retenção
	null            as vICMSRet,    -- Valor do ICMS retido
	null            as CFOPRet,     -- CFOP do Transporte
	null            as cMunFGRet,   -- Cód. do município de ocorrência do Fato Gerador do ICMS do Transp.
	-- Veic Transp
	null            as veicPlaca,   -- Placa do veículo
	null            as veicUF,      -- Sigla da UF
	null            as veicRNTC,    -- Registro Nacional de Transportador de Carga (ANTT)
	null            as veicVagao,   -- Identificação do Vagão
	null            as veicBalsa,   -- Identificação da Balsa
	null			as veicReboque  -- Dados do reboque/Dolly (v2.0)
	-- Dados de Cobrança
	null            as nFat,        -- Número da Fatura
	null            as vOrig,       -- Valor original da Fatura
	null            as fatVDesc,    -- Valor do desconto
	null            as vLiq,        -- Valor líquido da fatura
	-- Informações adicionais
	null            as infAdFisco,  -- Informações adicionais de interesse do FISCO
	null            as infCpl,      -- Informações Complementares de interesse do Contribuinte
	-- Informações de Comércio Exterior
	null            as UFSaidaPais  -- Sigla da UF de embarque ou de transposição de fronteira (nao aceita 'EX')
	null            as xLocExporta, -- Descrição do Local de Embarque ou de transposição de fronteira
	null            as xLocDespacho,-- Descrição do local de despacho
	-- Informações de compra
	null            as xNEmp,       -- Nota de Empenho
	null            as xPed,        -- Pedido
	null            as xCont,       -- Contrato
	-- Informações de aquisição de Cana
	null            as safra,       -- Identificação da safra
	null            as ref,         -- Mês e ano de referência
	null            as qTotMes,     -- Quantidade Total do Mês
	null            as qTotAnt,     -- Quantidade Total Anterior
	null            as qTotGer,     -- Quantidade Total Geral
	null            as vFor,        -- Valor dos Fornecimentos
	null            as vTotDed,     -- Valor Total da Dedução
	null            as vLiqFor,      -- Valor Líquido dos Fornecimentos 
	null            as indIntermed,  -- Indicador de intermediador/marketplace
	-- Infomações do Intermediador da Transação infIntermed
	null            as infIntermedCNPJ,      -- CNPJ do Intermediador da Transação (agenciador, plataforma de delivery, marketplace e similar) de serviços e de negócios.
	null            as idCadIntTran,         --  Identificador cadastrado no intermediador 
	-- Informações de pagamento 
	null 			as vTroco     	-- Valor do troco
	
	-- CAMPOS REFERENTE A REFORMA TRIBUTARIA NT 2025.002
	NULL AS dPrevEntrega, -- Data da previsão de entrega ou disponibilização do bem.
	NULL AS cMunFGIBS, -- Código do Município do fato gerador do IBS/CBS
    NULL AS tpNFDebito, -- Tipo da Nota de Débito
    NULL AS tpNFCredito, -- Tipo da Nota de Crédito
    NULL AS tpEnteGov, -- Tipo de Ente Governamental
    NULL AS pRedutor, -- Percentual de redução da alíquota
	NULL AS	tpOperGov, -- Tipo de operação com o ente governamental
	NULL AS	refNFe, -- Chave de acesso da NF-e de antecipação de pagamento
	-- TOTALIZADORES
    -- ISTot
    NULL AS vIS, -- Valor total do Imposto Seletivo
    -- IBSCBSTot
    NULL AS vBCIBSCBS, -- Base de cálculo do IBS/CBS
    -- gIBS
    -- gIBSUF
    NULL AS vDifIBSUF, -- Valor do Diferimento do IBS UF
    NULL AS vDevTribIBSUF, -- Valor do Tributo Devolvido IBS UF
    NULL AS vIBSUF, -- Valor do IBS da UF
    -- gIBSMun
    NULL AS vDifIBSMun, -- Valor do Diferimento do IBS Município
    NULL AS vDevTribIBSMun, -- Valor do Tributo Devolvido IBS Município
    NULL AS vIBSMun, -- Valor do IBS do Município
    NULL AS vIBS, -- Valor total do IBS
    NULL AS vCredPresIBS, -- Valor do Crédito Presumido IBS
    NULL AS vCredPresCondSusIBS, -- Valor do Crédito Presumido Condição Suspensiva IBS
    -- gCBS
    NULL AS vCredPresCBS, -- Valor do Crédito Presumido CBS
    NULL AS vCredPresCondSusCBS, -- Valor do Crédito Presumido Condição Suspensiva CBS
    NULL AS vDifCBS, -- Valor do Diferimento da CBS
    NULL AS vDevTribCBS, -- Valor do Tributo Devolvido da CBS
    NULL AS vCBS, -- Valor total da CBS
    -- gMono
    NULL AS vIBSMono, -- Valor total do IBS monofásico
    NULL AS vCBSMono, -- Valor total da CBS monofásico
    NULL AS vIBSMonoReten, -- Valor do IBS monofásico sujeito a retenção
    NULL AS vCBSMonoReten, -- Valor do CBS monofásico sujeito a retenção
    NULL AS vIBSMonoRet, -- Valor do IBS monofásico retido anteriormente
    NULL AS vCBSMonoRet, -- Valor do CBS monofásico retido anteriormente
	NULL AS vIBSEstCred, -- Valor total do IBS estornado
	NULL AS vCBSEstCred, -- Valor total da CBS estornada
    NULL AS vNFTot, -- Valor total da nota fiscal eletrônica
from <tabela> tab
-- Condição para o extrator Oobj-NFe ler o registro.
where <condition> 
